/*
 * Trigger_CAN_RX_BusCAN_1_Buf1.c
 *
 */

/*---- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include "Application.h"
#include "Controller.h"
#include "Controller_private.h"

/*---- CODE SPACE -----------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_text_code.h>
#include <Pragma_Section_End_data.h>
#include <Pragma_Section_End_bss.h>

/*
   Bus: CAN_1 (std)









   Masked IDs: CAN_1 (std)


   masked_id = 0x00000430
   masked_id = 0x00000460
   masked_id = 0x00000432
   masked_id = 0x00000453
   masked_id = 0x00000463
   masked_id = 0x00000440
   masked_id = 0x00000450

   Masks: CAN_1 (std)
   computed mask = 0x0000078C
   computed id   = 0x00000400

 */

/*---------------------------------------------------------------*/
MHCAN_directslot MHCAN_directslot_RxSlot_645p0004 = { 0 };

static boolean_T MHCAN_handler_RxSlot_645p0004(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000430) {
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;

    {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_645p0004.ready;
      MHCAN_directslot_RxSlot_645p0004.message = *messageObj;
      MHCAN_directslot_RxSlot_645p0004.ready = 1;
    }

    return 1;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_648p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_648p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000460) {
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;

    {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_648p0001.ready;
      MHCAN_directslot_RxSlot_648p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_648p0001.ready = 1;
    }

    return 1;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_649p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_649p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000432) {
    boolean_T good_payload = 1;
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;
    if (messageObj->u1Length < 1) {
      good_payload = 0;
    }

    if (good_payload) {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_649p0001.ready;
      MHCAN_directslot_RxSlot_649p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_649p0001.ready = 1;
    }

    return good_payload;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_650p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_650p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000453) {
    boolean_T good_payload = 1;
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;
    if (messageObj->u1Length < 1) {
      good_payload = 0;
    }

    if (good_payload) {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_650p0001.ready;
      MHCAN_directslot_RxSlot_650p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_650p0001.ready = 1;
    }

    return good_payload;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_651p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_651p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000463) {
    boolean_T good_payload = 1;
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;
    if (messageObj->u1Length < 1) {
      good_payload = 0;
    }

    if (good_payload) {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_651p0001.ready;
      MHCAN_directslot_RxSlot_651p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_651p0001.ready = 1;
    }

    return good_payload;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_647p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_647p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000440) {
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;

    {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_647p0001.ready;
      MHCAN_directslot_RxSlot_647p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_647p0001.ready = 1;
    }

    return 1;
  }

  return 0;
}

MHCAN_directslot MHCAN_directslot_RxSlot_646p0001 = { 0 };

static boolean_T MHCAN_handler_RxSlot_646p0001(S_CANMessage *messageObj)
{
  if ((messageObj->u4MessageID & 0x000007FF) == 0x00000450) {
    messageObj->u1Length = messageObj->u1Length > 8 ? 8 : messageObj->u1Length;

    {
      boolean_T new_message;
      new_message = !MHCAN_directslot_RxSlot_646p0001.ready;
      MHCAN_directslot_RxSlot_646p0001.message = *messageObj;
      MHCAN_directslot_RxSlot_646p0001.ready = 1;
    }

    return 1;
  }

  return 0;
}

static const MHCAN_id_dispatcher_T MHCAN_consumers_0x000007FF[] = {
  { 0x00000430, MHCAN_handler_RxSlot_645p0004 },

  { 0x00000460, MHCAN_handler_RxSlot_648p0001 },

  { 0x00000432, MHCAN_handler_RxSlot_649p0001 },

  { 0x00000453, MHCAN_handler_RxSlot_650p0001 },

  { 0x00000463, MHCAN_handler_RxSlot_651p0001 },

  { 0x00000440, MHCAN_handler_RxSlot_647p0001 },

  { 0x00000450, MHCAN_handler_RxSlot_646p0001 },
};

static const MHCAN_mask_dispatcher_T masks[] = {
  { 0x000007FF, 7, 0, (MHCAN_id_dispatcher_T *) MHCAN_consumers_0x000007FF },
};

/*---------------------------------------------------------------*/
void Trigger_CAN_RX_BusCAN_1_Buf1(E_TouCANNotificationEventMask in_EventMask,
  TouCANBufferHandle in_BufferHandle, NativePtrSizedInt_U in_uAppSuppliedData)
{
  S_CANMessage messageObj;
  NativeError_S sErrorResult;
  unsigned char idx;
  uint32_T maskidx;
  boolean_T handled;
  do {
    handled = 0;
    sErrorResult = SynchReadFromTouCAN(RES_CAN1, TOUCAN_BUFF1, &messageObj, 0);
    if (SUCCESS(sErrorResult)) {
      for (maskidx=0; maskidx < 1; maskidx++) {
        uint32_T ididx;
        if (!masks[maskidx].optimized_dispatcher) {
          for (ididx=0; ididx < masks[maskidx].consumer_count; ididx++) {
            if (masks[maskidx].consumer_list[ididx].consumer(&messageObj)) {
              handled = 1;
            }
          }
        } else {
          if (masks[maskidx].optimized_dispatcher(masks[maskidx].mask,
               masks[maskidx].consumer_list, &messageObj)) {
            handled = 1;
          }
        }
      }

      VolatileWork.mh_CAN_1_std_receive_count++;
      if (handled) {
        VolatileWork.mh_CAN_1_std_handled_count++;
      } else {
        VolatileWork.mh_CAN_1_std_last_unhandled_id = messageObj.u4MessageID;
      }

      if (sErrorResult == SUCCESS_Q_EMPTY)
        return;
    }
  } while (SUCCESS(sErrorResult));
}

/*---- END OF FILE -----------------------------------------------------------------------------------------*/
